<?xml version="1.0" encoding="UTF-8"?>
<!-- El objetivo de este archivo SLD, es el de simbolizar la entidad urbanística correspondiente según lo indicado en la "Instrucción técnica de estandarización y normalización de instrumentos de planeamiento (ITU-PL1)". Antes de su uso deberá revisar las etiquetas que hacen referencia a los campos existentes en las tablas de datos, especialmente los destinados a simbolizar por categorías, los de elementos alfanuméricos y los de geometría. Su definición puede admitir variantes y ser mejorada. Si es el caso, por favor, comparta su conocimiento para que futuros usuarios puedan beneficiarse. Gracias. | Murcia, mayo de 2024 | SERVICIO DE URBANISMO | https://www.urbmurcia.es/web/urbmurcia/contacto | -->
<sld:StyledLayerDescriptor xmlns="http://www.opengis.net/sld" xmlns:sld="http://www.opengis.net/sld" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" version="1.0.0">
	<sld:NamedLayer>
		<sld:Name>03_clasificacion_suelo</sld:Name>
		<sld:UserStyle>
			<sld:Name>03_clasificacion_suelo</sld:Name>
			<sld:FeatureTypeStyle>
				<sld:Name>name</sld:Name>
				<sld:Rule>
					<sld:Name>etiqueta</sld:Name>
					<sld:Title/>
					<sld:Abstract/>
					<sld:TextSymbolizer>
						<sld:Label>
							<ogc:PropertyName>Código</ogc:PropertyName>
						</sld:Label>
						<sld:Font>
							<sld:CssParameter name="font-family">Liberation Mono</sld:CssParameter>
							<sld:CssParameter name="font-size">14</sld:CssParameter>
							<sld:CssParameter name="font-style">normal</sld:CssParameter>
							<sld:CssParameter name="font-weight">bold</sld:CssParameter>
						</sld:Font>
						<sld:LabelPlacement>
							<sld:PointPlacement>
								<sld:AnchorPoint>
									<sld:AnchorPointX>0.5</sld:AnchorPointX>
									<sld:AnchorPointY>0.5</sld:AnchorPointY>
								</sld:AnchorPoint>
								<sld:Displacement>
									<sld:DisplacementX>0.0</sld:DisplacementX>
									<sld:DisplacementY>0.0</sld:DisplacementY>
								</sld:Displacement>
							</sld:PointPlacement>
						</sld:LabelPlacement>
						<sld:Fill>
							<sld:CssParameter name="fill">#8C145A</sld:CssParameter>
						</sld:Fill>
					</sld:TextSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>(U) Urbano</sld:Name>
					<sld:Title>(U) Urbano</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>U</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<sld:PolygonSymbolizer>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#8C145A</sld:CssParameter>
							<sld:CssParameter name="stroke-width">0.75</sld:CssParameter>
						</sld:Stroke>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>(Z) Urbanizable</sld:Name>
					<sld:Title>(Z) Urbanizable</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>Z</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<sld:PolygonSymbolizer>
						<sld:Fill>
							<sld:GraphicFill>
								<sld:Graphic>
									<sld:Mark>
										<sld:WellKnownName>shape://times</sld:WellKnownName>
										<sld:Stroke>
											<sld:CssParameter name="stroke">#999999</sld:CssParameter>
										</sld:Stroke>
									</sld:Mark>
									<sld:Size>11.0</sld:Size>
									<sld:Rotation>45.0</sld:Rotation>
								</sld:Graphic>
							</sld:GraphicFill>
						</sld:Fill>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#8C145A</sld:CssParameter>
							<sld:CssParameter name="stroke-width">0.75</sld:CssParameter>
						</sld:Stroke>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>(N) No Urbanizable</sld:Name>
					<sld:Title>(N) No Urbanizable</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>N</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<sld:PolygonSymbolizer>
						<sld:Fill>
							<sld:GraphicFill>
								<sld:Graphic>
									<sld:Mark>
										<sld:WellKnownName>shape://plus</sld:WellKnownName>
										<sld:Stroke>
											<sld:CssParameter name="stroke">#999999</sld:CssParameter>
										</sld:Stroke>
									</sld:Mark>
									<sld:Size>6.0</sld:Size>
								</sld:Graphic>
							</sld:GraphicFill>
						</sld:Fill>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#8C145A</sld:CssParameter>
							<sld:CssParameter name="stroke-width">0.75</sld:CssParameter>
						</sld:Stroke>
						<sld:VendorOption name="random">grid</sld:VendorOption>
						<sld:VendorOption name="random-tile-size">16</sld:VendorOption>
						<sld:VendorOption name="random-symbol-count">10</sld:VendorOption>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>(G) Sistema General</sld:Name>
					<sld:Title>(G) Sistema General</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Código</ogc:PropertyName>
							<ogc:Literal>G</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<sld:PolygonSymbolizer>
						<sld:Fill>
							<sld:GraphicFill>
								<sld:Graphic>
									<sld:Mark>
										<sld:WellKnownName>shape://horline</sld:WellKnownName>
										<sld:Stroke>
											<sld:CssParameter name="stroke">#999999</sld:CssParameter>
										</sld:Stroke>
									</sld:Mark>
									<sld:Size>11.0</sld:Size>
								</sld:Graphic>
							</sld:GraphicFill>
						</sld:Fill>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#8C145A</sld:CssParameter>
							<sld:CssParameter name="stroke-width">0.75</sld:CssParameter>
						</sld:Stroke>
					</sld:PolygonSymbolizer>
				</sld:Rule>
			</sld:FeatureTypeStyle>
		</sld:UserStyle>
	</sld:NamedLayer>
</sld:StyledLayerDescriptor>